/*###############################################################################
# Linux Management Providers (LMP), Boot provider package
# Copyright (C) 2009 Nodir Nazarov <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "OpenDRIM_BootConfigSettingAccess.h"

const string instanceID="Default";
string systemName;

int Boot_OpenDRIM_BootConfigSetting_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	CF_assert(CF_getSystemName(systemName, errorMessage));
	_L_;
	return OK;
}

int Boot_OpenDRIM_BootConfigSetting_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int Boot_OpenDRIM_BootConfigSetting_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_BootConfigSetting>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	OpenDRIM_BootConfigSetting instance;
	instance.setInstanceID(instanceID);
	
	if(discriminant=="ei")
		CF_assert(Boot_OpenDRIM_BootConfigSetting_populate(instance,errorMessage));
	
	result.push_back(instance);
	_L_;
	return OK;
}

int Boot_OpenDRIM_BootConfigSetting_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_BootConfigSetting& instance, const char** properties, string& errorMessage) {
	_E_;
	if (instance.InstanceID!=instanceID)
	{
		errorMessage = "No instance";
		return NOT_FOUND;
	}
	
	CF_assert(Boot_OpenDRIM_BootConfigSetting_populate(instance,errorMessage));
	_L_;
	return OK;
}

int Boot_OpenDRIM_BootConfigSetting_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootConfigSetting& newInstance, const OpenDRIM_BootConfigSetting& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Boot_OpenDRIM_BootConfigSetting_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootConfigSetting& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Boot_OpenDRIM_BootConfigSetting_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootConfigSetting& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Boot_OpenDRIM_BootConfigSetting_ChangeBootOrder(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootConfigSetting& instance, unsigned int& returnValue, const OpenDRIM_BootConfigSetting_ChangeBootOrder_In& in, OpenDRIM_BootConfigSetting_ChangeBootOrder_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int Boot_OpenDRIM_BootConfigSetting_ValidateSettings(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootConfigSetting& instance, unsigned int& returnValue, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int Boot_OpenDRIM_BootConfigSetting_populate(OpenDRIM_BootConfigSetting& instance, string& errorMessage) {
	_E_;
	instance.setElementName("Default Boot configuration");
	_L_;
	return OK;
}

