% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/virtualenv.R
\name{virtualenv-tools}
\alias{virtualenv-tools}
\alias{virtualenv_create}
\alias{virtualenv_install}
\alias{virtualenv_remove}
\alias{virtualenv_list}
\alias{virtualenv_root}
\alias{virtualenv_python}
\alias{virtualenv_exists}
\alias{virtualenv_starter}
\title{Interface to Python Virtual Environments}
\usage{
virtualenv_create(
  envname = NULL,
  python = virtualenv_starter(version),
  ...,
  version = NULL,
  packages = "numpy",
  requirements = NULL,
  force = FALSE,
  module = getOption("reticulate.virtualenv.module"),
  system_site_packages = getOption("reticulate.virtualenv.system_site_packages", default
    = FALSE),
  pip_version = getOption("reticulate.virtualenv.pip_version", default = NULL),
  setuptools_version = getOption("reticulate.virtualenv.setuptools_version", default =
    NULL),
  extra = getOption("reticulate.virtualenv.extra", default = NULL)
)

virtualenv_install(
  envname = NULL,
  packages = NULL,
  ignore_installed = FALSE,
  pip_options = character(),
  requirements = NULL,
  ...,
  python_version = NULL
)

virtualenv_remove(envname = NULL, packages = NULL, confirm = interactive())

virtualenv_list()

virtualenv_root()

virtualenv_python(envname = NULL)

virtualenv_exists(envname = NULL)

virtualenv_starter(version = NULL, all = FALSE)
}
\arguments{
\item{envname}{The name of, or path to, a Python virtual environment. If this
name contains any slashes, the name will be interpreted as a path; if the
name does not contain slashes, it will be treated as a virtual environment
within \code{virtualenv_root()}. When \code{NULL}, the virtual environment as
specified by the \code{RETICULATE_PYTHON_ENV} environment variable will be used
instead. To refer to a virtual environment in the current working
directory, you can prefix the path with \verb{./<name>}.}

\item{python}{The path to a Python interpreter, to be used with the created
virtual environment. This can also accept a version constraint like
\code{"3.10"}, which is passed on to \code{virtualenv_starter()} to find a suitable
python binary.}

\item{...}{Optional arguments; currently ignored and reserved for future
expansion.}

\item{version, python_version}{(string) The version of Python to use when
creating a virtual environment. Python installations will be searched for
using \code{\link[=virtualenv_starter]{virtualenv_starter()}}. This can a specific version, like \code{"3.9"}
or \code{"3.9.3"}, or a comma separated list of version constraints, like
\code{">=3.8"}, or \code{"<=3.11,!=3.9.3,>3.6"}}

\item{packages}{A set of Python packages to install (via \verb{pip install}) into
the virtual environment, after it has been created. By default, the
\code{"numpy"} package will be installed, and the \code{pip}, \code{setuptools} and
\code{wheel} packages will be updated. Set this to \code{FALSE} to avoid installing
any packages after the virtual environment has been created.}

\item{requirements}{Filepath to a pip requirements file.}

\item{force}{Boolean; force recreating the environment specified by
\code{envname}, even if it already exists. If \code{TRUE}, the pre-existing
environment is first deleted and then recreated. Otherwise, if \code{FALSE} (the
default), the path to the existing environment is returned.}

\item{module}{The Python module to be used when creating the virtual
environment -- typically, \code{virtualenv} or \code{venv}. When \code{NULL} (the
default), \code{venv} will be used if available with Python >= 3.6; otherwise,
the \code{virtualenv} module will be used.}

\item{system_site_packages}{Boolean; create new virtual environments with the
\code{--system-site-packages} flag, thereby allowing those virtual environments
to access the system's site packages? Defaults to \code{FALSE}.}

\item{pip_version}{The version of \code{pip} to be installed in the virtual
environment. Relevant only when \code{module == "virtualenv"}. Set this to
\code{FALSE} to disable installation of \code{pip} altogether.}

\item{setuptools_version}{The version of \code{setuptools} to be installed in the
virtual environment. Relevant only when \code{module == "virtualenv"}. Set this
to \code{FALSE} to disable installation of \code{setuptools} altogether.}

\item{extra}{An optional set of extra command line arguments to be passed.
Arguments should be quoted via \code{shQuote()} when necessary.}

\item{ignore_installed}{Boolean; ignore previously-installed versions of the
requested packages? (This should normally be \code{TRUE}, so that pre-installed
packages available in the site libraries are ignored and hence packages are
installed into the virtual environment.)}

\item{pip_options}{An optional character vector of additional command line
arguments to be passed to \code{pip}.}

\item{confirm}{Boolean; confirm before removing packages or virtual
environments?}

\item{all}{If \code{TRUE}, \code{virtualenv_starter()} returns a 2-column data frame,
with column names \code{path} and \code{version}. If \code{FALSE}, only a single path to a
python binary is returned, corresponding to the first entry when \code{all = TRUE}, or \code{NULL} if no suitable python binaries were found.}
}
\description{
R functions for managing Python \href{https://virtualenv.pypa.io/en/stable/}{virtual environments}.
}
\details{
Virtual environments are by default located at \verb{~/.virtualenvs} (accessed
with the \code{virtualenv_root()} function). You can change the default location
by defining the \code{WORKON_HOME} environment variable.

Virtual environments are created from another "starter" or "seed" Python
already installed on the system. Suitable Pythons installed on the system are
found by \code{virtualenv_starter()}.
}
