class HttpError extends Exception {
	protected Str msg;

	init(Str msg) {
		init { msg = msg; }
		saveTrace();
	}

	protected void message(StrBuf to) : override {
		to << "HTTP error: " << msg;
	}
}

class HttpParseError extends HttpError {
	private Nat pos;
	private Str msg;

	init (Nat position, Str message) {
		init(message) {
			pos = position;
		}
	}

	protected void message(StrBuf to) : override {
		to << "Error parsing HTTP request at position: " << pos << "\n" << msg;
	}
}

