## TFSA-2020-016: Segfault due to invalid splits in RaggedCountSparseOutput

### CVE Number
CVE-2020-15200

### Impact
The `RaggedCountSparseOutput` implementation does not validate that the input
arguments form a valid ragged tensor. In particular, there is no validation that
the values in the `splits` tensor generate a valid partitioning of the `values`
tensor. Thus, the [following
code](https://github.com/tensorflow/tensorflow/blob/0e68f4d3295eb0281a517c3662f6698992b7b2cf/tensorflow/core/kernels/count_ops.cc#L248-L265
) sets up conditions to cause a heap buffer overflow:
```cc
    auto per_batch_counts = BatchedMap<W>(num_batches);
    int batch_idx = 0;
    for (int idx = 0; idx < num_values; ++idx) {
      while (idx >= splits_values(batch_idx)) {
        batch_idx++;
      }
      const auto& value = values_values(idx);
      if (value >= 0 && (maxlength_ <= 0 || value < maxlength_)) {
        per_batch_counts[batch_idx - 1][value] = 1;
      }
    }
```

A `BatchedMap` is equivalent to a vector where each element is a hashmap.
However, if the first element of `splits_values` is not 0, `batch_idx` will
never be 1, hence there will be no hashmap at index 0 in `per_batch_counts`.
Trying to access that in the user code results in a segmentation fault.

### Vulnerable Versions
TensorFlow 2.3.0.

### Patches
We have patched the issue in
[3cbb917b4714766030b28eba9fb41bb97ce9ee02](https://github.com/tensorflow/tensorflow/commit/3cbb917b4714766030b28eba9fb41bb97ce9ee02)
and will release a patch release.

We recommend users to upgrade to TensorFlow 2.3.1.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been discovered through a variant analysis of [a
vulnerability reported by members of the Aivul Team from Qihoo
360](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-015.md).
