## TFSA-2021-026: Heap buffer overflow in `QuantizedReshape`

### CVE Number
CVE-2021-29536

### Impact
An attacker can cause a heap buffer overflow in `QuantizedReshape` by
passing in invalid thresholds for the quantization:

```python
import tensorflow as tf

tensor = tf.constant([], dtype=tf.qint32)
shape = tf.constant([], dtype=tf.int32)
input_min = tf.constant([], dtype=tf.float32)
input_max = tf.constant([], dtype=tf.float32)

tf.raw_ops.QuantizedReshape(tensor=tensor, shape=shape, input_min=input_min, input_max=input_max)
```

This is because the
[implementation](https://github.com/tensorflow/tensorflow/blob/a324ac84e573fba362a5e53d4e74d5de6729933e/tensorflow/core/kernels/quantized_reshape_op.cc#L38-L55)
assumes that the 2 arguments are always valid scalars and tries to access the
numeric value directly:

```cc
const auto& input_min_float_tensor = ctx->input(2);
...
const float input_min_float = input_min_float_tensor.flat<float>()(0);
const auto& input_max_float_tensor = ctx->input(3);
...
const float input_max_float = input_max_float_tensor.flat<float>()(0);
```

However, if any of these tensors is empty, then `.flat<T>()` is an empty buffer
and accessing the element at position 0 results in overflow.

### Patches
We have patched the issue in GitHub commit
[a324ac84e573fba362a5e53d4e74d5de6729933e](https://github.com/tensorflow/tensorflow/commit/a324ac84e573fba362a5e53d4e74d5de6729933e).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by Ying Wang and Yakun Zhang of Baidu X-Team.
