## TFSA-2021-116: Heap OOB in `RaggedGather`

### CVE Number
CVE-2021-37641

### Impact
If the arguments to `tf.raw_ops.RaggedGather` don't determine a valid ragged
tensor code can trigger a read from outside of bounds of heap allocated buffers.

```python
import tensorflow as tf

tf.raw_ops.RaggedGather(
  params_nested_splits = [0,0,0],
  params_dense_values = [1,1],
  indices = [0,0,9,0,0],
  OUTPUT_RAGGED_RANK=0)
```

In debug mode, the same code triggers a `CHECK` failure.

The
[implementation](https://github.com/tensorflow/tensorflow/blob/8d72537c6abf5a44103b57b9c2e22c14f5f49698/tensorflow/core/kernels/ragged_gather_op.cc#L70)
directly reads the first dimension of a tensor shape before checking that said
tensor has rank of at least 1 (i.e., it is not a scalar). Furthermore, the
implementation does not check that the list given by `params_nested_splits` is
not an empty list of tensors.

### Patches
We have patched the issue in GitHub commit
[a2b743f6017d7b97af1fe49087ae15f0ac634373](https://github.com/tensorflow/tensorflow/commit/a2b743f6017d7b97af1fe49087ae15f0ac634373).

The fix will be included in TensorFlow 2.6.0. We will also cherrypick this
commit on TensorFlow 2.5.1, TensorFlow 2.4.3, and TensorFlow 2.3.4, as these are
also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
