## TFSA-2022-013: `CHECK`-failures in `MapStage`

### CVE Number
CVE-2022-21734

### Impact
The [implementation of `MapStage`](https://github.com/tensorflow/tensorflow/blob/5100e359aef5c8021f2e71c7b986420b85ce7b3d/tensorflow/core/kernels/map_stage_op.cc#L519-L550) is vulnerable a `CHECK`-fail if the key tensor is not a scalar:

```python
import tensorflow as tf
import numpy as np

tf.raw_ops.MapStage(
    key = tf.constant(value=[4], shape= (1,2), dtype=tf.int64),
    indices = np.array([[6]]),
    values = np.array([-60]),
    dtypes = [tf.int64], capacity=0, memory_limit=0,
    container='', shared_name='', name=None
)
```

### Patches
We have patched the issue in GitHub commit [f57315566d7094f322b784947093406c2aea0d7d](https://github.com/tensorflow/tensorflow/commit/f57315566d7094f322b784947093406c2aea0d7d).

The fix will be included in TensorFlow 2.8.0. We will also cherrypick this commit on TensorFlow 2.7.1, TensorFlow 2.6.3, and TensorFlow 2.5.3, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability has been reported by Faysal Hossain Shezan from University of Virginia.
