## TFSA-2023-006: NPE in SparseSparseMaximum

### CVE Number
CVE-2023-25665

### Impact
When `SparseSparseMaximum` is given invalid sparse tensors as inputs, it can give an NPE. 

```python
import tensorflow as tf
tf.raw_ops.SparseSparseMaximum(
 a_indices=[[1]],
 a_values =[ 0.1 ],
 a_shape = [2],
 b_indices=[[]],
 b_values =[2 ],
 b_shape = [2],
)
```

### Patches
We have patched the issue in GitHub commit [5e0ecfb42f5f65629fd7a4edd6c4afe7ff0feb04](https://github.com/tensorflow/tensorflow/commit/5e0ecfb42f5f65629fd7a4edd6c4afe7ff0feb04).

The fix will be included in TensorFlow 2.12. We will also cherrypick this commit on TensorFlow 2.11.1.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by Yu Tian of Qihoo 360 AIVul Team





