// DESCRIPTION: Verilator: Verilog Test module
//
// This file ONLY is placed under the Creative Commons Public Domain, for
// any use, without warranty, 2023 by Antmicro Ltd.
// SPDX-License-Identifier: CC0-1.0

int static_var;

module t();
  event evt;
  task send_event();
    ->evt;
  endtask


  class Foo;
    task do_something(int captured_var);
      fork
        begin
          int my_var;
          int my_other_var;
          my_var = captured_var;
          my_other_var = captured_var; /* Capture the same value "twice" */
          my_var++;
          static_var++; /* Write to a value with static lifetime (valid) */
          $display("Vars in forked process: %0d %0d", my_var, my_other_var);
          if (my_var != 2)
            $stop;
          if (my_other_var != 1)
            $stop;
          send_event();
        end
      join_none
      $display("Leaving fork's parent");
    endtask
  endclass

  initial begin
    Foo foo;
    foo = new;
    static_var = 0;
    foo.do_something(1);

  end

  always @(evt) begin
    $display("Static variable: %0d", static_var);
    if (static_var != 1)
      $stop;
    fork
      begin
          automatic int my_auto_var = 0;
          my_auto_var++;
          $display("Automatic variable in fork: %0d", my_auto_var);
          if (my_auto_var != 1) $stop;
      end
    join_none
    $write("*-* All Finished *-*\n");
    $finish;
  end
endmodule
